<?php
/**
 * Call To Action Second Block Template.
 *
 * @param array $block The block settings and attributes.
 * @param string $content The block inner HTML (empty).
 * @param bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */
// Create id attribute allowing for custom "anchor" value.
$id = 'cta-second' . $block['id'];
if ( ! empty( $block['anchor'] ) ) {
	$id = $block['anchor'];
}
// Create class attribute allowing for custom "className" and "align" values.
$className = 'cta-second';
if ( ! empty( $block['className'] ) ) {
	$className .= ' ' . $block['className'];
}
if ( ! empty( $block['align'] ) ) {
	$className .= ' align' . $block['align'];
}

$attrs = get_acf_block_style_attributes($block);
$title     = get_field( 'title' );
$content     = get_field( 'content' );
$link_button     = get_field( 'link_button' );
$left_image     = get_field( 'left_image' );
$right_image     = get_field( 'right_image' );

$background_color = $attrs['background_color'] ?? '';
$padding_top = $attrs['padding_top'] ?? '';
$padding_bottom = $attrs['padding_bottom'] ?? '';
$margin_top = $attrs['margin_top'] ?? '';
$margin_bottom = $attrs['margin_bottom'] ?? '';

$style = '';
if ($padding_top) {
    $style .= 'padding-top:' . $padding_top . ';';
}
if ($padding_bottom) {
    $style .= 'padding-bottom:' . $padding_bottom . ';';
}
if ($margin_top) {
    $style .= 'margin-top:' . $margin_top . ';';
}
if ($margin_bottom) {
    $style .= 'margin-bottom:' . $margin_bottom . ';';
}

?>

<section class="<?php echo $background_color; ?> h-auto" <?php if ($style) echo 'style="' . esc_attr($style) . '"'; ?>>
    <div class="relative w-3xl mx-auto sm:px-6 lg:px-17 py-56 ">
         <?php if( !empty( $left_image['url'] && isset( $left_image['url'] ) ) ): ?>
        <div class="absolute left-2/16 top-[-120px] bg-iron p-3 -rotate-2 w-80"> <img
                src="<?php echo $left_image['url'] ?>"
                class="object-contain"
                alt="<?php echo $left_image['alt'] ?>" />
        </div>
        <?php endif; ?>

        <div class="absolute top-[-200px] left-1/2 -translate-x-1/2 bg-secondary px-12 py-10 z-10 w-[352px] rotate-1">
            <div class="flex flex-col gap-4 willarong-icon willarong-icon-small">
                <?php if( !empty( $title ) ): ?>
                <h3 class="!text-4xl !leading-9 text-center"><?php echo $title; ?></h3>
                <?php endif; ?>
                <?php if( !empty( $content) ): ?>
                <p class="text-center pb-12"><?php echo $content; ?></p>
                <?php endif; ?>
                <?php 
                    if( is_array( $link_button ) && isset( $link_button['url'] ) ):					
                        $target_blank = '';
                        if( $link_button['target'] ){
                            $target_blank = 'target="_blank"';
                        }else{
                            $target_blank = '';
                        }    				
                    ?> 
                <a href="<?php echo $link_button['url']; ?>" <?php  echo $target_blank; ?> class="bg-brown text-white text-xl text-center font-ArtificialSans py-5 px-10 rounded-full inline-block z-10 relative"><?php echo $link_button['title']; ?></a>
                <?php endif; ?>
            </div>
        </div>
         <?php if( !empty( $right_image['url'] && isset( $right_image['url'] ) ) ): ?>
        <div class="absolute right-0 top-[-160px] bg-rockblue p-2 rotate-2 w-80"> <img
                src="<?php echo $right_image['url'] ?>"
                class=" object-contain"
                alt="<?php echo $right_image['alt'] ?>" /></div>
                 <?php endif; ?>
    </div>
</section>