<?php
/**
 * Call To Action Block Template.
 *
 * @param array $block The block settings and attributes.
 * @param string $content The block inner HTML (empty).
 * @param bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */
// Create id attribute allowing for custom "anchor" value.
$id = 'call-to-action' . $block['id'];
if ( ! empty( $block['anchor'] ) ) {
	$id = $block['anchor'];
}
// Create class attribute allowing for custom "className" and "align" values.
$className = 'call-to-action';
if ( ! empty( $block['className'] ) ) {
	$className .= ' ' . $block['className'];
}
if ( ! empty( $block['align'] ) ) {
	$className .= ' align' . $block['align'];
}

$title     = get_field( 'title' );
$content     = get_field( 'content' );
$left_image     = get_field( 'left_image' );
$right_image     = get_field( 'right_image' );
$button_link     = get_field( 'button_link' );

$attrs = get_acf_block_style_attributes($block);
$background_color = $attrs['background_color'] ?? '';
$padding_top = $attrs['padding_top'] ?? '';
$padding_bottom = $attrs['padding_bottom'] ?? '';
$margin_top = $attrs['margin_top'] ?? '';
$margin_bottom = $attrs['margin_bottom'] ?? '';

$style = '';
if ($background_color) {
    $style .= 'background-color:' . $background_color . ';';
}
if ($padding_top) {
    $style .= 'padding-top:' . $padding_top . ';';
}
if ($padding_bottom) {
    $style .= 'padding-bottom:' . $padding_bottom . ';';
}
if ($margin_top) {
    $style .= 'margin-top:' . $margin_top . ';';
}
if ($margin_bottom) {
    $style .= 'margin-bottom:' . $margin_bottom . ';';
}
?>
<section class="bg-secondary py-10 text-center" <?php if ($style) echo 'style="' . esc_attr($style) . '"'; ?>>

    <div class="w-full mx-auto sm:px-6 lg:px-17">
        <?php if( !empty( $title ) ): ?>
        <h1 class="text-5xl m-10"><?php echo $title; ?></h1>
        <?php endif; ?>
        <div class="flex ">
            <?php if( !empty( $left_image['url'] && isset( $left_image['url'] ) ) ): ?>
            <div class="flex-1"><img src="<?php echo $left_image['url'] ?>" alt="<?php echo $left_image['alt'] ?>" class="max-h-full max-w-full object-contain"></div>
            <?php endif; ?>
            <div class="flex-1 space-y-5 willarong-icon">
                <?php if( !empty( $content ) ): ?>
                <p class="mb-10 text-xl"><?php echo $content; ?></p>
                <?php endif; ?>
                 <?php 
                    if( is_array( $button_link ) && isset( $button_link['url'] ) ):					
                        $target_blank = '';
                        if( $button_link['target'] ){
                            $target_blank = 'target="_blank"';
                        }else{
                            $target_blank = '';
                        }    				
                    ?>   
                <a href="<?php echo $button_link['url']; ?>" <?php  echo $target_blank; ?> class="bg-salem text-white text-2xl font-ArtificialSans py-5 px-10 rounded-full inline-block z-10 relative"><?php echo $button_link['title']; ?></a>
                <?php endif; ?>
            </div>
            <?php if( !empty( $right_image['url'] && isset( $right_image['url'] ) ) ): ?>
            <div class="flex-1"><img src="<?php echo $right_image['url'] ?>" alt="<?php echo $right_image['alt'] ?>" class="max-h-full max-w-full object-contain"></div>
            <?php endif; ?>
        </div>
    </div>
</section>