<?php

/**
 * Contact Block Template.
 *
 * @param array $block The block settings and attributes.
 * @param string $content The block inner HTML (empty).
 * @param bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */
// Create id attribute allowing for custom "anchor" value.
$id = 'contact' . $block['id'];
if (! empty($block['anchor'])) {
    $id = $block['anchor'];
}
// Create class attribute allowing for custom "className" and "align" values.
$className = 'contact';
if (! empty($block['className'])) {
    $className .= ' ' . $block['className'];
}
if (! empty($block['align'])) {
    $className .= ' align' . $block['align'];
}

$title     = get_field('title');
$content     = get_field('content');
$form_title     = get_field('form_title');
$form_shortcode     = get_field('form_shortcode');

$attrs = get_acf_block_style_attributes($block);
$background_color = $attrs['background_color'] ?? '';
$padding_top = $attrs['padding_top'] ?? '';
$padding_bottom = $attrs['padding_bottom'] ?? '';
$margin_top = $attrs['margin_top'] ?? '';
$margin_bottom = $attrs['margin_bottom'] ?? '';

$style = '';
if ($background_color) {
    $style .= 'background-color:' . $background_color . ';';
}
if ($padding_top) {
    $style .= 'padding-top:' . $padding_top . ';';
}
if ($padding_bottom) {
    $style .= 'padding-bottom:' . $padding_bottom . ';';
}
if ($margin_top) {
    $style .= 'margin-top:' . $margin_top . ';';
}
if ($margin_bottom) {
    $style .= 'margin-bottom:' . $margin_bottom . ';';
}
?>
<section class="bg-primary contact-section pt-35 pb-25" <?php if ($style) echo 'style="' . esc_attr($style) . '"'; ?>>
    <div class="w-full mx-auto sm:px-6 lg:px-17">
        <div class="flex flex-col lg:flex-row">
            <div class="flex-1">
                <?php if (!empty($title)): ?>
                    <h2 class="text-5xl !mb-5 text-white"><?php echo $title; ?>
                    </h2>
                <?php endif; ?>

                <?php if (!empty($content)): ?>
                    <p class="mb-10 text-xl text-white"><?php echo $content; ?></p>
                <?php endif; ?>

                <?php
                $email_address_one = get_field('email_address_one', 'option');
                $email_address_two = get_field('email_address_two', 'option');
                $email_address_three = get_field('email_address_three', 'option');
                ?>
                <ul class="!list-none !mx-0">
                    <?php if (!empty($email_address_one)): ?>
                        <li class="text-white"><a href="mailto:<?php echo $email_address_one; ?>"><?php echo $email_address_one; ?></a></li>
                    <?php endif; ?>

                    <?php if (!empty($email_address_two)): ?>
                        <li class="text-white"><a href="mailto:<?php echo $email_address_two; ?>"><?php echo $email_address_two; ?></a></li>
                    <?php endif; ?>

                    <?php if (!empty($email_address_three)): ?>
                        <li class="text-white"><a href="mailto:<?php echo $email_address_three; ?>"><?php echo $email_address_three; ?></a></li>
                    <?php endif; ?>
                </ul>

                <?php
                $address = get_field('address', 'option');
                $contact_number = get_field('contact_number', 'option');
                ?>
                <?php if (!empty($address)): ?>
                    <p class="text-white"><?php echo $address; ?></p>
                <?php endif; ?>
                <?php if (!empty($contact_number)): ?>
                    <p>
                        <a href="tel:<?php echo $contact_number; ?>" class="text-dust"><?php echo $contact_number; ?></a>
                    </p>
                <?php endif; ?>

                <?php
                $opening_hours = get_field('opening_hours', 'option');
                //   debug($opening_hours);
                ?>
                <div class="flex mt-10">
                    <?php if (!is_wp_error($opening_hours) && !empty($opening_hours)): ?>
                        <div class="flex-1">
                            <h5 class="!text-base !font-HalyardDisplayRegular text-dust mb-4 uppercase">
                                <?php echo esc_html__('OPENING HOURS BARS HOUR', 'willaraong'); ?>
                            </h5>

                            <ul class="!list-none !m-0">
                                <?php foreach ($opening_hours as $opening_hour) {
                                ?>
                                    <li class="text-white"><span class="text-rockblue"><?php echo $opening_hour['opening_days']; ?></span><b class="font-HalyardDisplaySemiBold"><?php echo $opening_hour['opening_time']; ?></b></li>
                                <?php
                                } ?>
                            </ul>

                        </div>
                    <?php endif; ?>

                    <?php
                    $bar_hours = get_field('bar_hours', 'option');
                    //debug($bar_hours);
                    ?>
                    <?php if (!is_wp_error($bar_hours) && !empty($bar_hours)): ?>
                        <div class="flex-1">
                            <h5 class="!text-base !font-HalyardDisplayRegular text-dust mb-4 uppercase">
                                <?php echo esc_html__('BARS HOUR', 'willaraong'); ?></h5>
                            <ul class="!list-none !m-0">
                                <?php
                                foreach ($bar_hours as $bar_hour) {
                                ?>
                                    <li class="text-white"><span class="text-rockblue"><?php echo $bar_hour['opening_bar_days']; ?></span><b class="font-HalyardDisplaySemiBold"><?php echo $bar_hour['opening_bar_time']; ?></b></li>
                                <?php
                                }
                                ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                </div>

            </div>
            <div class="flex-1 lg:pl-10 lg:pt-0 pt-10">
                <div class="bg-rockblue p-5">

                    <div class="border-secondary border-6 p-5">
                        <?php if (!empty($form_title)): ?>
                            <h3><?php echo $form_title; ?>
                            </h3>
                        <?php endif; ?>

                        <?php echo $form_shortcode; ?>
                    </div>



                </div>
            </div>
        </div>

    </div>
    </div>
</section>