<?php
/**
 * Events Block Template.
 *
 * @param array $block The block settings and attributes.
 * @param string $content The block inner HTML (empty).
 * @param bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */
// Create id attribute allowing for custom "anchor" value.
$id = 'events' . $block['id'];
if (!empty($block['anchor'])) {
    $id = $block['anchor'];
}
// Create class attribute allowing for custom "className" and "align" values.
$className = 'events';
if (!empty($block['className'])) {
    $className .= ' ' . $block['className'];
}
if (!empty($block['align'])) {
    $className .= ' align' . $block['align'];
}

$attrs = get_acf_block_style_attributes($block);
$title_and_content_style = get_field('title_and_content_style');
$title = get_field('title');
$content = get_field('content');
$post_count = get_field('post_count') ? get_field('post_count') : 4 ;

$background_color = $attrs['background_color'] ?? 'secondary-bg';
$padding_top = $attrs['padding_top'] ?? '';
$padding_bottom = $attrs['padding_bottom'] ?? '';
$margin_top = $attrs['margin_top'] ?? '';
$margin_bottom = $attrs['margin_bottom'] ?? '';
$text_color = $attrs['text_color'] ?? '';
$border = $attrs['border'] ?? '';
$border_color = $attrs['border_color'] ?? '';

$style = '';
if ($padding_top) {
    $style .= 'padding-top:' . $padding_top . ';';
}
if ($padding_bottom) {
    $style .= 'padding-bottom:' . $padding_bottom . ';';
}
if ($margin_top) {
    $style .= 'margin-top:' . $margin_top . ';';
}
if ($margin_bottom) {
    $style .= 'margin-bottom:' . $margin_bottom . ';';
}

?>
<section class="event-section <?php echo $background_color . ' ' . $border . ' ' . $border_color; ?> pt-10 pb-25" <?php if ($style)
    echo 'style="' . esc_attr($style) . '"'; ?>>
    <div class="w-full mx-auto sm:px-6 lg:px-17">
        <?php
        $style_class = '';
        $style_container_full = '';
        if ($title_and_content_style == 'left') {
            $style_class = '';
            $style_container_full = 'w-full';
        } else {
            $style_class = 'text-center m-auto';
            $style_container_full = 'w-xl';
        }
        ?>
        <div class="<?php echo $style_class . ' ' . $style_container_full; ?> ">
            <?php if (!empty($title)): ?>
                <h1 class="text-5xl mb-5 <?php echo $text_color; ?>"><?php echo $title; ?></h1>
            <?php endif; ?>
            <?php if (!empty($content)): ?>
                <p class="mb-10 text-xl <?php echo $text_color; ?>"><?php echo $content; ?></p>
            <?php endif; ?>
        </div>
        <?php
        //debug($events_list);
        $events_args = array(
            'post_type' => 'events',
            'post_status' => 'publish',
            'posts_per_page' => $post_count,
            'order' => 'DESC'
        );

        $events_query = new WP_Query($events_args);

        // debug($events_query);

        // if ($events_query->have_posts()) {
            ?>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                <?php
                while ($events_query->have_posts()) {
                    $events_query->the_post();

                    $thumbnail_id = get_post_thumbnail_id(get_the_ID());

                    if ($thumbnail_id) {
                        $image_url = get_the_post_thumbnail_url(get_the_ID(), 'blog-post-crop');
                        $alt_text = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
                    }

                    $trimmed_content = wp_trim_words(get_the_content(), 12, ' ...');
                    ?>
                    <div class="<?php echo $text_color; ?>">
                        <a href="<?php echo get_the_permalink(get_the_ID()); ?>">
                            <img src="<?php echo $image_url; ?>" alt="<?php echo $alt_text; ?>" />
                        </a>
                        <h3 class="text-darkblue !text-2xl mt-4">
                            <a href="<?php echo get_the_permalink(); ?>" class="hover:underline">
                                <?php echo esc_html(get_the_title()); ?>
                            </a>
                        </h3>
                        <p><?php echo esc_html($trimmed_content); ?></p>
                    </div>
                    <?php

                }
                wp_reset_postdata();
                ?>
            </div>
            <?php
        // }
?>
    </div>
</section>