<?php
/**
 * Image Banner Block Template.
 *
 * @param array $block The block settings and attributes.
 * @param string $content The block inner HTML (empty).
 * @param bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */
// Create id attribute allowing for custom "anchor" value.
$id = 'image-banner' . $block['id'];
if ( ! empty( $block['anchor'] ) ) {
	$id = $block['anchor'];
}
// Create class attribute allowing for custom "className" and "align" values.
$className = 'image-banner';
if ( ! empty( $block['className'] ) ) {
	$className .= ' ' . $block['className'];
}
if ( ! empty( $block['align'] ) ) {
	$className .= ' align' . $block['align'];
}

$hero_image     = get_field( 'hero_image' );
$hero_image_url = '';
if ( ! empty( $hero_image['ID'] ) ) {
    $hero_image_id  = $hero_image['ID'];
    $hero_image_url = wp_get_attachment_image_url( $hero_image_id, 'full' );
    $hero_image_alt  = $hero_image['alt'];
}else{
     $hero_image_url = get_template_directory_uri().'/assets/Rectangle.png';
}

$upper_gif_image     = get_field( 'upper_gif_image' );
$upper_gif_image_url = '';
if ( ! empty( $upper_gif_image['ID'] ) ) {
    $upper_gif_image_id  = $upper_gif_image['ID'];
    $upper_gif_image_url = wp_get_attachment_image_url( $upper_gif_image_id, 'full' );
    $upper_gif_image_alt  = $upper_gif_image['alt'];
}else{
     $upper_gif_image_url = get_template_directory_uri().'/assets/YOUR.gif';
}

$center_image     = get_field( 'center_image' );
$center_image_url = '';
if ( ! empty( $center_image['ID'] ) ) {
    $center_image_id  = $center_image['ID'];
    $center_image_url = wp_get_attachment_image_url( $center_image_id, 'full' );
    $center_image_alt  = $center_image['alt'];
}else{
     $center_image_url = get_template_directory_uri().'/assets/TW-InstagramGridindividualtiles-298x300.png';
}

$lower_gif_image     = get_field( 'lower_gif_image' );
$lower_gif_image_url = '';
if ( ! empty( $lower_gif_image['ID'] ) ) {
    $lower_gif_image_id  = $lower_gif_image['ID'];
    $lower_gif_image_url = wp_get_attachment_image_url( $lower_gif_image_id, 'full' );
    $lower_gif_image_alt  = $lower_gif_image['alt'];
}else{
     $lower_gif_image_url = get_template_directory_uri().'/assets/LOCAL.gif';
}
// debug($hero_image);
?>
<section class="relative h-screen w-full overflow-hidden overlay">

    <img src="<?php echo $hero_image_url; ?>" alt="<?php echo $hero_image_alt; ?>" class="absolute top-0 left-0 w-full h-full object-cover z-0">

    <div class="h-screen flex items-center justify-center z-10 relative">
        <div class="grid grid-rows-3 gap-4 w-full">
            <div class="p-6 flex items-center justify-center h-40">
                <img src="<?php echo $upper_gif_image_url; ?>" alt="<?php echo $upper_gif_image_alt; ?>" class="max-h-full max-w-full" />
            </div>
            <div class="p-6 flex items-center justify-center h-40">
                <img src="<?php echo $center_image_url; ?>" alt="<?php echo $center_image_alt; ?>" class="max-h-full max-w-full" />
            </div>
            <div class="p-6 flex items-center justify-center h-40">
                <img src="<?php echo $lower_gif_image_url; ?>" alt="<?php echo $lower_gif_image_alt; ?>" class="max-h-full max-w-full" />
            </div>
        </div>
    </div>
    <!-- Hero Content -->

</section>