<?php
/**
 * Image Content Block Template.
 *
 * @param array $block The block settings and attributes.
 * @param string $content The block inner HTML (empty).
 * @param bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */
// Create id attribute allowing for custom "anchor" value.
$id = 'image-content' . $block['id'];
if ( ! empty( $block['anchor'] ) ) {
	$id = $block['anchor'];
}
// Create class attribute allowing for custom "className" and "align" values.
$className = 'image-content';
if ( ! empty( $block['className'] ) ) {
	$className .= ' ' . $block['className'];
}
if ( ! empty( $block['align'] ) ) {
	$className .= ' align' . $block['align'];
}

$attrs = get_acf_block_style_attributes($block);
$title     = get_field( 'title' );
$content     = get_field( 'content' );
$button_link     = get_field( 'button_link' );
$center_image     = get_field( 'center_image' );
$left_image     = get_field( 'left_image' );
$right_image     = get_field( 'right_image' );

$background_color = $attrs['background_color'] ?? 'secondary-bg';
$padding_top = $attrs['padding_top'] ?? '';
$padding_bottom = $attrs['padding_bottom'] ?? '';
$margin_top = $attrs['margin_top'] ?? '';
$margin_bottom = $attrs['margin_bottom'] ?? '';

$style = '';
if ($padding_top) {
    $style .= 'padding-top:' . $padding_top . ';';
}
if ($padding_bottom) {
    $style .= 'padding-bottom:' . $padding_bottom . ';';
}
if ($margin_top) {
    $style .= 'margin-top:' . $margin_top . ';';
}
if ($margin_bottom) {
    $style .= 'margin-bottom:' . $margin_bottom . ';';
}

?>
<section class="<?php echo $background_color; ?> pt-25 pb-[300px]" <?php if ($style) echo 'style="' . esc_attr($style) . '"'; ?>>
    <div class="w-full mx-auto sm:px-6 lg:px-17">
        <div class="flex">
            <div class="flex-1 pr-8 pt-10">
                <h2 class="text-3xl mb-5 text-white pr-15"> 
                    <?php echo $title; ?>
                </h2>
                <p class="text-white mb-10"><?php echo $content; ?></p>
                <?php 
                if( is_array( $button_link ) && isset( $button_link['url'] ) ):					
                    $target_blank = '';
                    if( $button_link['target'] ){
                        $target_blank = 'target="_blank"';
                    }else{
                        $target_blank = '';
                    }    				
                ?>   
                <a href="<?php echo $button_link['url']; ?>" <?php  echo $target_blank; ?>  class="bg-brown text-white text-2xl font-ArtificialSans py-5 px-10 rounded-full inline-block z-10 relative"><?php echo $button_link['title']; ?></a>
                <?php endif; ?>
            </div>

            <?php 
            $center_image_url = '';
            if ( ! empty( $center_image['ID'] ) ) :
                $center_image_id  = $center_image['ID'];
                $center_image_url = wp_get_attachment_image_url( $center_image_id, 'full' );
                $center_image_alt  = $center_image['alt'];            
                ?>
            <div class="flex-1"><img src="<?php echo $center_image_url; ?>" alt="<?php echo $center_image_alt; ?>"  /></div>
            <?php endif; ?>  

            <div class="flex-1 pl-8 space-y-6">
                <!-- First image aligned LEFT -->
                <?php 
                $left_image_url = '';
                if ( ! empty( $left_image['ID'] ) ) :
                    $left_image_id  = $left_image['ID'];
                    $left_image_url = wp_get_attachment_image_url( $left_image_id, 'full' );
                    $left_image_alt  = $left_image['alt'];
                
                 ?>
                <div class="flex justify-start">
                    <img
                        src="<?php echo $left_image_url; ?>"
                        class="w-1/2 object-contain"
                        alt="<?php echo $left_image_alt; ?>" />
                </div>
                <?php endif; ?>    
                <!-- Second image aligned RIGHT -->

                <?php 
                $right_image_url = '';
                if ( ! empty( $right_image['ID'] ) ) :
                $right_image_id  = $right_image['ID'];
                $right_image_url = wp_get_attachment_image_url( $right_image_id, 'full' );
                $right_image_alt  = $right_image['alt'];            
                ?>
                <div class="flex justify-end">
                    <img
                        src="<?php echo $right_image_url; ?>"
                        class="w-1/2 object-contain"
                        alt="<?php echo $right_image_alt; ?>" />
                </div>
                 <?php endif; ?>    
            </div>
        </div>
    </div>
</section>