<?php
/**
 * Inner page Banner Block Template.
 *
 * @param array $block The block settings and attributes.
 * @param string $content The block inner HTML (empty).
 * @param bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */
// Create id attribute allowing for custom "anchor" value.
$id = 'inner-page-banner' . $block['id'];
if ( ! empty( $block['anchor'] ) ) {
	$id = $block['anchor'];
}
// Create class attribute allowing for custom "className" and "align" values.
$className = 'inner-page-banner';
if ( ! empty( $block['className'] ) ) {
	$className .= ' ' . $block['className'];
}
if ( ! empty( $block['align'] ) ) {
	$className .= ' align' . $block['align'];
}

$title     = get_field( 'title' );
$banner_image     = get_field( 'banner_image' );
$the_title = get_the_title();
?>
<!-- Intro -->
<section class="relative h-[70vh] w-full overflow-hidden overlay">
    <?php if( !empty( $banner_image['url'] ) && isset( $banner_image['url'] ) ): ?>
    <img src="<?php echo $banner_image['url']; ?>" alt="<?php echo $banner_image['alt']; ?>" class="absolute top-0 left-0 w-full h-full object-cover z-0">
    <?php endif; ?>

    <div class="flex items-center justify-center h-full relative z-10">
        
        <div class="flex flex-col items-center justify-center gap-1 w-full max-w-md">
            <h1 class="text-white !text-7xl text-center"><?php echo !empty($title) ? $title : $the_title; ?></h1>
        </div>
        
    </div>
    <!-- Hero Content -->
</section>