<?php
/**
 * Map Block Template.
 *
 * @param array $block The block settings and attributes.
 * @param string $content The block inner HTML (empty).
 * @param bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */
// Create id attribute allowing for custom "anchor" value.
$id = 'map' . $block['id'];
if ( ! empty( $block['anchor'] ) ) {
	$id = $block['anchor'];
}
// Create class attribute allowing for custom "className" and "align" values.
$className = 'map';
if ( ! empty( $block['className'] ) ) {
	$className .= ' ' . $block['className'];
}
if ( ! empty( $block['align'] ) ) {
	$className .= ' align' . $block['align'];
}

$map_iframe     = get_field( 'map_iframe' );

$attrs = get_acf_block_style_attributes($block);
// $background_color = $attrs['background_color'] ?? '';
$padding_top = $attrs['padding_top'] ?? '';
$padding_bottom = $attrs['padding_bottom'] ?? '';
$margin_top = $attrs['margin_top'] ?? '';
$margin_bottom = $attrs['margin_bottom'] ?? '';

$style = '';

if ($padding_top) {
    $style .= 'padding-top:' . $padding_top . ';';
}
if ($padding_bottom) {
    $style .= 'padding-bottom:' . $padding_bottom . ';';
}
if ($margin_top) {
    $style .= 'margin-top:' . $margin_top . ';';
}
if ($margin_bottom) {
    $style .= 'margin-bottom:' . $margin_bottom . ';';
}

?>

<section <?php if ($style) echo 'style="' . esc_attr($style) . '"'; ?>>
    <?php  if( !empty( $map_iframe ) ):   ?>
    <?php echo $map_iframe; ?>
    <?php endif; ?>
</section>