<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package willarong
 */

?>


	<footer id="colophon" class="site-footer">
		<section class="bg-darkblue">
			<div class="border-primary/50 border-t-1 w-full mx-auto sm:px-6 lg:px-17 py-24">
				<div class="flex flex-col  gap-20">
					<div class="flex">

						<?php 
							$opening_hours = get_field('opening_hours', 'option');
						   //debug($opening_hours);
							?>
						<?php if( !is_wp_error($opening_hours) && !empty( $opening_hours )): ?>
						<div class="flex-1">
							<h5 class="!text-lg !font-HalyardDisplayRegular text-dust mb-4 uppercase"><?php echo esc_html__( 'OPENING HOURS', 'willaraong' ); ?></h5>
							<ul class="!list-none !m-0">

								<?php foreach ($opening_hours as $opening_hour) {
									?>
									<li class="text-white"><span class="text-rockblue"><?php echo $opening_hour['opening_days']; ?></span><b class="font-HalyardDisplaySemiBold"><?php echo $opening_hour['opening_time']; ?></b></li>
									<?php                                
								} ?>
							</ul>
						</div>
						<?php endif; ?>

						<?php 
						$address = get_field('address', 'option');
						?>
						<div class="flex-1">
							<div class="flex-1">
								<h5 class="!text-lg !font-HalyardDisplayRegular text-dust mb-4 uppercase"><?php echo esc_html__( 'ADDRESS', 'willaraong' ); ?></h5>
								<ul class="!list-none !m-0">
									<li class="text-white"><?php echo $address; ?></li>

								</ul>
							</div>
						</div>

						<div class="flex-1">
							<div class="flex-1">
								
								<?php if( is_active_sidebar( 'footer-widget-1' ) ): ?>
									<?php dynamic_sidebar( 'footer-widget-1' ); ?>
								<?php endif; ?> 

							</div>
						</div>
						<div class="flex-1">
							<div class="flex-1">
								<?php if( is_active_sidebar( 'footer-widget-2' ) ): ?>
									<?php dynamic_sidebar( 'footer-widget-2' ); ?>
								<?php endif; ?> 
							</div>
						</div>

						<?php
						$contact_number = get_field('contact_number', 'option');
						$email_address_one = get_field('email_address_one', 'option');
						$email_address_two = get_field('email_address_two', 'option');
						$email_address_three = get_field('email_address_three', 'option');
						?>
						<div class="flex-1">
							<div class="flex-1">
								<h5 class="!text-lg !font-HalyardDisplayRegular text-dust mb-4 uppercase"> <?php echo esc_html__( 'CONTACT US', 'willaraong' ); ?></h5>

								<ul class="!list-none !m-0">
									<li class="text-white">
										<a href="tel:<?php echo $contact_number; ?>"><?php echo $contact_number; ?></a>
									</li>
									<?php if( !empty( $email_address_one ) ): ?>
									<li class="text-white">
										<a href="mailto:<?php echo $email_address_one; ?>"><?php echo $email_address_one; ?></a>
									</li>
									<?php endif; ?>

									<?php if( !empty( $email_address_two ) ): ?>
									<li class="text-white">
										<a href="mailto:<?php echo $email_address_two; ?>"><?php echo $email_address_two; ?></a>
									</li>
									<?php endif; ?>

									<?php if( !empty( $email_address_three ) ): ?>
									<li class="text-white">
										<a href="mailto:<?php echo $email_address_three; ?>"><?php echo $email_address_three; ?></a>
									</li>
									<?php endif; ?>
								</ul>
							</div>
						</div>
					</div>
					<div class="flex">
						<?php 
						$social_link_items = get_field('social_link_items', 'option');
					//	debug($social_link_items);
						?>
						<div class="flex-1">
							<h5 class="!text-lg !font-HalyardDisplayRegular text-dust mb-4 uppercase"> <?php echo esc_html__( 'Get Social', 'willaraong' ); ?></h5>
							<div class="inline-flex gap-2">
								<?php if( is_array($social_link_items) && isset( $social_link_items['facebook'] ) ): ?>
								<a href="<?php echo $social_link_items['facebook']; ?>"><img src="<?php echo site_url() . '/wp-content/themes/willarong/assets/facebook.png'; ?>" alt="facebook-logo"></a>
								<?php endif; ?>

								<?php if( is_array($social_link_items) && isset( $social_link_items['instagram'] ) ): ?>
								<a href="<?php echo $social_link_items['instagram']; ?>"><img src="<?php echo site_url() . '/wp-content/themes/willarong/assets/instagram.png'; ?>" alt="instagram-logo"></a>
								<?php endif; ?>

							</div>
						</div>

						<?php 
							$copyright_text = get_field('copyright_text', 'option'); 
							$footer_logo = get_field('footer_logo', 'option'); 
							$logo_url = $footer_logo ? esc_url($footer_logo['url']) : get_template_directory_uri() . '/assets/logo-footer-willarong.png';
						?>
						<div class="flex-1"> 
							<a href="<?php echo esc_url(site_url()); ?>"><img src="<?php echo $logo_url; ?>" alt="<?php echo $footer_logo['alt']; ?>"></a>
						</div>
						<div class="flex-1 self-end">
							<p class="text-white text-right">
								<?php 
									printf(
										esc_html__( '© %s The Willarong. Website by %s', 'willarong' ),
										date('Y'),
										'<span class="text-dust"><a href="https://ozlcoal.com.au">ozlocal</a></span>'
									); 
								?>
							</p>
						</div>
					</div>
				</div>
			</div>
		</section>

		<?php /* ?>
		<div class="site-info">
			<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'willarong' ) ); ?>">
				<?php
				
				printf( esc_html__( 'Proudly powered by %s', 'willarong' ), 'WordPress' );
				?>
			</a>
			<span class="sep"> | </span>
				<?php
			
				printf( esc_html__( 'Theme: %1$s by %2$s.', 'willarong' ), 'willarong', '<a href="https://ozlcoal.com.au">Waiba</a>' );
				?>
		</div>
		<?php */ ?>

	</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
