<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package willarong
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site bg-gray-300">
		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'willarong'); ?></a>

		<header id="masthead" class="site-header">

			<?php
			/*<div class="site-branding">
					<?php
					the_custom_logo();
					if (is_front_page() && is_home()):
						?>
						<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"
								rel="home"><?php bloginfo('name'); ?></a></h1>
						<?php
					else:
						?>
						<p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"
								rel="home"><?php bloginfo('name'); ?></a></p>
						<?php
					endif;
					$willarong_description = get_bloginfo('description', 'display');
					if ($willarong_description || is_customize_preview()):
						?>
						<p class="site-description">
							<?php echo $willarong_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</p>
					<?php endif; ?>
				</div><!-- .site-branding -->
				*/ ?>

			<nav class="bg-transparent">
				<div class="mx-auto w-full px-2 sm:px-6 lg:px-17 absolute z-99 ">
					<div class="relative flex h-40 items-center justify-between">
						<div class="absolute inset-y-0 left-0 flex items-center sm:hidden">
							<!-- Mobile menu button-->
							<button type="button"
								class="relative inline-flex items-center justify-center rounded-md p-2 text-gray-400 hover:bg-gray-700 hover:text-white focus:ring-2 focus:ring-white focus:outline-hidden focus:ring-inset"
								aria-controls="mobile-menu" aria-expanded="false">
								<span class="absolute -inset-0.5"></span>
								<span class="sr-only">Open main menu check</span>
								<!--
			Icon when menu is closed.

			Menu open: "hidden", Menu closed: "block"
		  -->
								<svg class="block size-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
									stroke="currentColor" aria-hidden="true" data-slot="icon">
									<path stroke-linecap="round" stroke-linejoin="round"
										d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" />
								</svg>
								<!--
			Icon when menu is open.

			Menu open: "block", Menu closed: "hidden"
		  -->
								<svg class="hidden size-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
									stroke="currentColor" aria-hidden="true" data-slot="icon">
									<path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
								</svg>
							</button>
						</div>
						<div class="flex flex-1 items-center justify-center sm:items-center sm:justify-start">
							<div class="flex shrink-0 items-center">
								<?php
								$logo = get_custom_logo();
								if (has_custom_logo()) {
									echo str_replace('<img', '<img class="h-24 w-auto"', $logo);
								}
								?>
							</div>
							<div class="hidden sm:block sm:ml-auto sm:mr-6 text-white">
								<!-- <div class="flex space-x-4"> -->
								
								<?php
								wp_nav_menu(
									array(
										'theme_location' => 'menu-1',
										'menu_id' => 'primary-menu',
										'menu_class' => 'flex space-x-6 li-none uppercase main-menu font-SFPRODISPLAYMEDIUM'
									)
								);
								?>
								<!-- </div> -->
							</div>
						</div>
						<div
							class="absolute inset-y-0 right-0 flex items-center pr-2 sm:static sm:inset-auto sm:ml-6 sm:pr-0">
							<!-- <a href="#"
								class="rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-gray-700 hover:text-white">Contact</a> -->

							<!-- Profile dropdown -->
							<div class="relative ml-3">
								<a href="<?php echo get_the_permalink('contact'); ?>"
									class="relative rounded-full 1bg-gray-800 px-4 py-3 text-gray-200 hover:text-white focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-gray-800 focus:outline-hidden uppercase bg-tertiary">
									<span class="absolute -inset-1.5"></span>
									<span class="sr-only">Contact Us</span>
									Contact Us
							</a>

								<!--
			Dropdown menu, show/hide based on menu state.

			Entering: "transition ease-out duration-100"
			  From: "transform opacity-0 scale-95"
			  To: "transform opacity-100 scale-100"
			Leaving: "transition ease-in duration-75"
			  From: "transform opacity-100 scale-100"
			  To: "transform opacity-0 scale-95"
		  -->
							</div>
						</div>
					</div>
				</div>

				<!-- Mobile menu, show/hide based on menu state. -->
				<div class="sm:hidden" id="mobile-menu">
					<div class="space-y-1 px-2 pt-2 pb-3">
						<?php
						wp_nav_menu(
							array(
								'theme_location' => 'menu-1',
								'menu_id' => 'primary-menu',
								'menu_class' => 'li-none uppercase main-menu'
							)
						);
						?>
						<!-- Current: "bg-gray-900 text-white", Default: "text-gray-300 hover:bg-gray-700 hover:text-white" -->
						<a href="#" class="block rounded-md bg-gray-900 px-3 py-2 text-base font-medium text-white"
							aria-current="page">Dashboard</a>
						<a href="#"
							class="block rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-gray-700 hover:text-white">Team</a>
						<a href="#"
							class="block rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-gray-700 hover:text-white">Projects</a>
						<a href="#"
							class="block rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-gray-700 hover:text-white">Calendar</a>
					</div>
				</div>
			</nav>

		</header><!-- #masthead -->

