<?php
function events_posttype() {

    $labels = array(
        'name'                => __( 'Events', 'willarong' ),
        'singular_name'       => __( 'Event', 'willarong' ),
        'add_new'             => _x( 'Add New Event', 'willarong', 'willarong' ),
        'add_new_item'        => __( 'Add New Event', 'willarong' ),
        'edit_item'           => __( 'Edit Event', 'willarong' ),
        'new_item'            => __( 'New Event', 'willarong' ),
        'view_item'           => __( 'View Event', 'willarong' ),
        'search_items'        => __( 'Search Event', 'willarong' ),
        'not_found'           => __( 'No Event found', 'willarong' ),
        'not_found_in_trash'  => __( 'No Event found in Trash', 'willarong' ),
        'parent_item_colon'   => __( 'Parent Event:', 'willarong' ),
        'menu_name'           => __( 'Event', 'willarong' ),
    );

    $args = array(
        'labels'              => $labels,
        'hierarchical'        => false,
        'description'         => 'Custom Post Type Created For Events',
        'taxonomies'          => array(),
        'public'              => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_admin_bar'   => true,
        'menu_position'       => null,
        'menu_icon'           => 'dashicons-admin-users',
        'show_in_nav_menus'   => true,
        'publicly_queryable'  => true,
        'exclude_from_search' => false,
        'has_archive'         => true,
        'query_var'           => true,
        'can_export'          => true,
        'rewrite'             => true,
        'capability_type'     => 'post',
        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'trackbacks', 'custom-fields', 'comments', 'revisions', 'page-attributes' ),
    );

    register_post_type( 'events', $args );
}
add_action( 'init', 'events_posttype' );

add_filter('manage_events_posts_columns', 'head_only_events');
add_action('manage_events_posts_custom_column', 'content_only_events', 15, 3);
//adding column in the listing of the At The Museums
function head_only_events($defaults) {
    $defaults['featured_image'] = 'Events Image';
    return $defaults;
}
function content_only_events($column_name, $post_ID) {
    if ($column_name == 'featured_image') {
        $post_thumbnail_id = get_post_thumbnail_id($post_ID);
        if ($post_thumbnail_id) {
            $post_thumbnail_img = wp_get_attachment_image_src($post_thumbnail_id, 'featured_preview');
            echo "<img src='".$post_thumbnail_img[0]."' width='80'/>";
        }
    }  
}