import { Rules } from './native-rules';
/**
 * Config class
 * @class
 */
export declare class Config {
    /**
     * The user passed config object.
     */
    config: any;
    /**
     * The current working directory.
     */
    cwd: string;
    /**
     * The user passed configFile path.
     */
    configFile: any;
    /**
     * The base directory that config should be pulled from.
     */
    configBaseDirectory: any;
    /**
     * Rules object
     */
    rules: any;
    constructor(cwd: string, config: any, configFile: any, configBaseDirectory: any, rules: Rules);
    /**
     * Gets the config for a file.
     *
     * @param filePath File path of the file being linted.
     * @returns {Object} A config object.
     * @memberof Config
     */
    getConfigForFile(filePath: string): any;
}
