import { PackageJson } from 'type-fest';
export interface IsInPreferredOrderResult {
    status: boolean;
    msg: string | null;
}
/**
 * Determines whether an array is in the specified order
 *
 * @param packageJsonData         Valid JSON
 * @param userPreferredNodeOrder Preferred order of nodes
 * @return Object containing the status and the node that is out of order, if applicable
 */
export declare const isInPreferredOrder: (packageJsonData: PackageJson | any, userPreferredNodeOrder: string[]) => IsInPreferredOrderResult;
