<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package willarong
 */

get_header();
?>

<main id="primary" class="site-main">
	<?php
	$banner_style = get_field('banner_style');
	$custom_hero_image = get_field('custom_hero_image');
	$hero_banner = get_field('hero_banner');
	$hero_image = get_field('hero_image');
	$title = get_field('title');
	// debug($custom_hero_image);
	
	$hero_image_url = '';
	if ($custom_hero_image) {
		if (!empty($hero_image['ID'])) {
			$hero_image_id = $hero_image['ID'];
			$hero_image_url = wp_get_attachment_image_url($hero_image_id, 'full');
			$hero_image_alt = $hero_image['alt'];
		} else {
			$hero_image_url = get_template_directory_uri() . '/assets/Rectangle.png';
		}
	} else {
		$hero_image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
		$hero_image_alt = get_the_title();
	}

	$upper_gif_image = get_field('upper_gif_image');
	$upper_gif_image_url = '';
	if (!empty($upper_gif_image['ID'])) {
		$upper_gif_image_id = $upper_gif_image['ID'];
		$upper_gif_image_url = wp_get_attachment_image_url($upper_gif_image_id, 'full');
		$upper_gif_image_alt = $upper_gif_image['alt'];
	} else {
		$upper_gif_image_url = get_template_directory_uri() . '/assets/YOUR.gif';
	}

	$center_image = get_field('center_image');
	$center_image_url = '';
	if (!empty($center_image['ID'])) {
		$center_image_id = $center_image['ID'];
		$center_image_url = wp_get_attachment_image_url($center_image_id, 'full');
		$center_image_alt = $center_image['alt'];
	} else {
		$center_image_url = get_template_directory_uri() . '/assets/TW-InstagramGridindividualtiles-298x300.png';
	}

	$lower_gif_image = get_field('lower_gif_image');
	$lower_gif_image_url = '';
	if (!empty($lower_gif_image['ID'])) {
		$lower_gif_image_id = $lower_gif_image['ID'];
		$lower_gif_image_url = wp_get_attachment_image_url($lower_gif_image_id, 'full');
		$lower_gif_image_alt = $lower_gif_image['alt'];
	} else {
		$lower_gif_image_url = get_template_directory_uri() . '/assets/LOCAL.gif';
	}
	// debug($hero_image);
	?>
	<section class="relative w-full overflow-hidden overlay <?php echo $banner_style == 'animated-text' ? 'h-screen' : 'h-[70vh]' ?>">

		<img src="<?php echo $hero_image_url; ?>" alt="<?php echo $hero_image_alt; ?>"
			class="absolute top-0 left-0 w-full h-full object-cover z-0">

		<?php
		if ($banner_style == 'animated-text') {
			?>
			<div class="h-screen flex items-center justify-center z-10 relative">
				<div class="grid grid-rows-3 gap-4 w-full">
					<div class="p-6 flex items-center justify-center h-40">
						<img src="<?php echo $upper_gif_image_url; ?>" alt="<?php echo $upper_gif_image_alt; ?>"
							class="max-h-full max-w-full" />
					</div>
					<div class="p-6 flex items-center justify-center h-40">
						<img src="<?php echo $center_image_url; ?>" alt="<?php echo $center_image_alt; ?>"
							class="max-h-full max-w-full" />
					</div>
					<div class="p-6 flex items-center justify-center h-40">
						<img src="<?php echo $lower_gif_image_url; ?>" alt="<?php echo $lower_gif_image_alt; ?>"
							class="max-h-full max-w-full" />
					</div>
				</div>
			</div>
			<!-- Hero Content -->
			<?php
		} else {

			$the_title = get_the_title();
			?>
			<div class="flex items-center justify-center h-full relative z-10">

				<div class="flex flex-col items-center justify-center gap-1 w-full max-w-4xl">
					<h1 class="text-white !text-7xl text-center"><?php echo !empty($title) ? $title : $the_title; ?></h1>
				</div>

			</div>
			<?php
		}
		?>

	</section>

	<?php
	while (have_posts()):
		the_post();
		the_content();
		// get_template_part( 'template-parts/content', 'page' );
	
		// // If comments are open or we have at least one comment, load up the comment template.
		// if ( comments_open() || get_comments_number() ) :
		// 	comments_template();
		// endif;
	
	endwhile; // End of the loop.
	?>

</main><!-- #main -->

<?php
//get_sidebar();
get_footer();
