<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package willarong
 */

get_header();
?>

<main id="primary" class="site-main secondary-bg">

	<?php
	$title = get_field('title');
	// debug($custom_hero_image);
	
		$hero_image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
		$hero_image_alt = get_the_title();

	
	// debug($hero_image);
	?>
	<section
		class="relative w-full overflow-hidden overlay h-[70vh]">

		<img src="<?php echo $hero_image_url; ?>" alt="<?php echo $hero_image_alt; ?>"
			class="absolute top-0 left-0 w-full h-full object-cover z-0">

		<?php


			$the_title = get_the_title();
			?>
			<div class="flex items-center justify-center h-full relative z-10">

				<div class="flex flex-col items-center justify-center gap-1 w-full max-w-4xl">
					<h1 class="text-white !text-7xl text-center"><?php echo $the_title; ?></h1>
				</div>

			</div>
	</section>

	<?php
	while (have_posts()):
		the_post();

		// get_template_part('template-parts/content', get_post_type());
		?>
		<section class="py-10 px-2 text-center lg:max-w-6xl mx-auto">
			<div class="w-full mx-auto sm:px-6 lg:px-17">
				<div class="content-area">
					<h1><?php echo get_the_title(); ?></h1>
					<?php the_content(); ?>
				</div>
			</div>
		</section>
		<?php

		/* the_post_navigation(
			array(
				'prev_text' => '<span class="nav-subtitle">' . esc_html__('Previous:', 'willarong') . '</span> <span class="nav-title">%title</span>',
				'next_text' => '<span class="nav-subtitle">' . esc_html__('Next:', 'willarong') . '</span> <span class="nav-title">%title</span>',
			)
		); */

		// If comments are open or we have at least one comment, load up the comment template.
		// if (comments_open() || get_comments_number()):
		// 	comments_template();
		// endif;

	endwhile; // End of the loop.
	?>

</main><!-- #main -->

<?php
// get_sidebar();
get_footer();
